document.addEventListener('DOMContentLoaded', function() {
    const filterButtons = document.querySelectorAll('.filter-btn');
    const workstationCards = document.querySelectorAll('.workstation-card');
    const categoryCards = document.querySelectorAll('.category-card');

    filterButtons.forEach(button => {
        button.addEventListener('click', function() {

            filterButtons.forEach(btn => btn.classList.remove('active'));

            this.classList.add('active');
            
            const filterValue = this.getAttribute('data-filter');
            

            workstationCards.forEach(card => {
                if (filterValue === 'all') {
                    card.style.display = 'block';
                } else {
                    if (card.getAttribute('data-category') === filterValue) {
                        card.style.display = 'block';
                    } else {
                        card.style.display = 'none';
                    }
                }
            });
        });
    });
    

    categoryCards.forEach(card => {
        card.addEventListener('click', function() {
            const category = this.getAttribute('data-category');
            
            workstationCards.forEach(workstation => {
                const workstationApps = workstation.getAttribute('data-apps');
                if (workstationApps.includes(category)) {
                    workstation.style.display = 'block';
                    workstation.scrollIntoView({ behavior: 'smooth', block: 'center' });
                } else {
                    workstation.style.display = 'none';
                }
            });
            

            filterButtons.forEach(btn => btn.classList.remove('active'));
            document.querySelector('.filter-btn[data-filter="all"]').classList.add('active');
        });
    });

    const consultationButtons = document.querySelectorAll('.workstation-actions .btn-primary');
    consultationButtons.forEach(button => {
        button.addEventListener('click', function() {
            const workstationCard = this.closest('.workstation-card');
            const workstationTitle = workstationCard.querySelector('.workstation-title').textContent;
            

            document.querySelector('.consultation-section').scrollIntoView({ 
                behavior: 'smooth' 
            });
            

            setTimeout(() => {
                alert(`Запрошена консультация по рабочей станции: ${workstationTitle}\nНаш специалист свяжется с вами в ближайшее время.`);
            }, 1000);
        });
    });
    

    const specButtons = document.querySelectorAll('.workstation-actions .btn-secondary');
    specButtons.forEach(button => {
        button.addEventListener('click', function() {
            const workstationCard = this.closest('.workstation-card');
            const workstationTitle = workstationCard.querySelector('.workstation-title').textContent;
            const workstationSpecs = workstationCard.querySelector('.workstation-specs').innerHTML;
            

            alert(`Детальная спецификация для ${workstationTitle} отправлена на ваш email.`);
        });
    });
    

    const consultationForm = document.querySelector('.consultation-form-inner');
    if (consultationForm) {
        consultationForm.addEventListener('submit', function(e) {
            e.preventDefault();
            alert('Спасибо за заявку! Наш специалист свяжется с вами в течение 30 минут.');
            this.reset();
        });
    }
});