document.addEventListener('DOMContentLoaded', function() {
    const chatMessages = document.getElementById('chatMessages');
    const chatInput = document.getElementById('chatInput');
    const sendBtn = document.getElementById('sendBtn');
    const quickBtns = document.querySelectorAll('.quick-btn');
    const buildForm = document.getElementById('buildForm');
    const approvalForm = document.getElementById('approvalForm');

    const botResponses = {
        'привет': 'Привет! Чем могу помочь? Вы можете задать вопрос или отправить свою сборку на одобрение.',
        'сборка': 'Отлично! Для отправки сборки на одобрение нажмите кнопку "Отправить сборку" ниже.',
        'гарантия': 'На все компьютеры VORTEX ARMORY предоставляется гарантия 2 года. На рабочие станции - 3 года.',
        'доставка': 'Доставка по России от 2 до 7 дней. В Москве и СПб - бесплатная доставка в день заказа.',
        'цена': 'Стоимость зависит от комплектующих. Отправьте свою сборку для точного расчёта.',
        'время': 'Сборка занимает 2-3 рабочих дня. Срочная сборка - 24 часа (+20% к стоимости).',
        'default': 'Понял ваш вопрос! Менеджер свяжется с вами в ближайшее время для уточнения деталей.'
    };

    function addMessage(text, isUser = false) {
        const messageDiv = document.createElement('div');
        messageDiv.className = `message ${isUser ? 'user-message' : 'bot-message'}`;
        
        const time = new Date().toLocaleTimeString('ru-RU', { 
            hour: '2-digit', 
            minute: '2-digit' 
        });

        messageDiv.innerHTML = `
            <div class="message-avatar">${isUser ? '👤' : '🤖'}</div>
            <div class="message-content">
                <p>${text}</p>
                <span class="message-time">${time}</span>
            </div>
        `;

        chatMessages.appendChild(messageDiv);
        chatMessages.scrollTop = chatMessages.scrollHeight;
    }


    function botReply(userMessage) {
        const lowerMessage = userMessage.toLowerCase();
        let response = botResponses.default;

        for (const [key, value] of Object.entries(botResponses)) {
            if (lowerMessage.includes(key)) {
                response = value;
                break;
            }
        }

        setTimeout(() => {
            addMessage(response);
        }, 1000);
    }

    function sendMessage() {
        const message = chatInput.value.trim();
        if (message) {
            addMessage(message, true);
            chatInput.value = '';
            botReply(message);
        }
    }

    sendBtn.addEventListener('click', sendMessage);

    chatInput.addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            sendMessage();
        }
    });

    quickBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            const action = this.getAttribute('data-action');
            
            switch(action) {
                case 'build':
                    addMessage('Хочу отправить свою сборку на одобрение', true);
                    buildForm.style.display = 'block';
                    buildForm.scrollIntoView({ behavior: 'smooth' });
                    setTimeout(() => {
                        addMessage('Отлично! Заполните форму ниже. Менеджер свяжется с вами в течение часа для согласования деталей.');
                    }, 1000);
                    break;
                    
                case 'consult':
                    addMessage('Нужна техническая консультация по сборке', true);
                    setTimeout(() => {
                        addMessage('Конечно! Опишите ваши требования: бюджет, назначение ПК (игры/работа), особые пожелания. Я помогу подобрать оптимальную конфигурацию.');
                    }, 1000);
                    break;
                    
                case 'order':
                    addMessage('Хочу узнать статус заказа', true);
                    setTimeout(() => {
                        addMessage('Для проверки статуса заказа укажите номер заказа или ваши контактные данные.');
                    }, 1000);
                    break;
                    
                case 'warranty':
                    addMessage('Интересует информация по гарантии', true);
                    setTimeout(() => {
                        addMessage('Гарантия на сборки VORTEX ARMORY: 2 года на игровые ПК, 3 года на рабочие станции. Включает бесплатную диагностику и ремонт.');
                    }, 1000);
                    break;
            }
        });
    });


    if (approvalForm) {
        approvalForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            const cpu = this.querySelector('input[placeholder*="процессор"]').value;
            const gpu = this.querySelector('input[placeholder*="видеокарта"]').value;
            const name = this.querySelector('input[placeholder*="имя"]').value;

            alert(`Спасибо, ${name}! Ваша сборка (${cpu} + ${gpu}) отправлена на одобрение.\nМенеджер свяжется с вами в течение часа.`);

            addMessage(`Отправил сборку на одобрение: ${cpu} + ${gpu}`, true);
            setTimeout(() => {
                addMessage('Сборка получена! Менеджер уже изучает вашу конфигурацию. Ожидайте звонка в течение часа для согласования деталей и стоимости.');
            }, 1000);

            this.reset();
        });
    }


    setTimeout(() => {
        addMessage('Чем могу помочь? Выберите действие из меню или задайте вопрос.');
    }, 500);
});