document.addEventListener('DOMContentLoaded', function() {
    const filterButtons = document.querySelectorAll('.filter-btn');
    const buildCards = document.querySelectorAll('.build-card');
    
    filterButtons.forEach(button => {
        button.addEventListener('click', function() {

            filterButtons.forEach(btn => btn.classList.remove('active'));
            
  
            this.classList.add('active');
            
            const filterValue = this.getAttribute('data-filter');
            

            buildCards.forEach(card => {
                if (filterValue === 'all') {
                    card.style.display = 'block';
                } else {
                    if (card.getAttribute('data-category') === filterValue) {
                        card.style.display = 'block';
                    } else {
                        card.style.display = 'none';
                    }
                }
            });
        });
    });
    

    const addToCartButtons = document.querySelectorAll('.btn-primary');
    addToCartButtons.forEach(button => {
        button.addEventListener('click', function() {
            const buildCard = this.closest('.build-card');
            const buildTitle = buildCard.querySelector('.build-title').textContent;
            const buildPrice = buildCard.querySelector('.build-price').textContent;

            alert(`Товар "${buildTitle}" добавлен в корзину!\nЦена: ${buildPrice}`);
        });
    });
    

    const configuratorButtons = document.querySelectorAll('.btn-secondary');
    configuratorButtons.forEach(button => {
        button.addEventListener('click', function() {
            const buildCard = this.closest('.build-card');
            const buildTitle = buildCard.querySelector('.build-title').textContent;
            

            alert(`Переход в конфигуратор для "${buildTitle}"`);
        });
    });
});